// Function to inject the footer into the DOM
function loadFooter() {
	const footerHTML = `
		<div class="container-xxl d-flex flex-column flex-md-row app-container flex-center flex-md-stack py-3">
			<div class="text-dark order-2 order-md-1">
				<span class="fw-semibold text-muted me-1">2025©</span>
				<a class="text-gray-800 text-hover-primary" href="https://score-now.com/" target="_blank">Score Now</a>
			</div>
			<ul class="fw-semibold order-1 menu menu-gray-600 menu-hover-primary">
				<li class="menu-item">
					<a class="menu-link px-2" href="faq.html" target="">FAQ</a>
				</li>
				<li class="menu-item">
					<a class="menu-link px-2" href="mailto:support@score-now.com" target="_blank">Contact</a>
				</li>
				<li class="menu-item">
					<a class="menu-link px-2" href="privacy.html" target="">Privacy Policy</a>
				</li>
				<li class="menu-item">
					<a class="menu-link px-2" href="imprint.html" target="">Imprint</a>
				</li>
			</ul>
		</div>
	`;

	// Append the footer HTML to the designated container
	const footerContainer = document.getElementById('footer-container');
	if (footerContainer) {
		footerContainer.innerHTML = footerHTML;
	} else {
		console.error("Footer container element not found!");
	}
}

// Initialize footer on DOMContentLoaded
document.addEventListener("DOMContentLoaded", loadFooter);