document.addEventListener("DOMContentLoaded", function () {
  /*******************************************************
   * 1) Minimal CSS injection (make alert full width)
   *******************************************************/
 const style = document.createElement("style");
 style.textContent = `
   .alert {
	 max-width: 640px;
	 width: 90vw;
	 margin: 3rem auto 2rem auto !important;
	 padding: 1.25rem 2rem;
	 font-size: 1.1rem;
	 border-width: 1px;
	 box-sizing: border-box;
	 display: block;
   }
   #kt_app_content_container .alert {
	 border-radius: 0.75rem;
	 box-shadow: 0 2px 8px 0 rgba(220,53,69,.04);
   }
   @media (max-width: 700px) {
	 .alert {
	   max-width: 98vw;
	   padding: 1rem;
	   margin: 2rem 1vw;
	 }
   }
 `;
 document.head.appendChild(style);

  /*******************************************************
   * 2) Get competition code from URL
   *******************************************************/
  const urlParams = new URLSearchParams(window.location.search);
  const competitionCode = urlParams.get("CompetitionCode");
  const mainContainer = document.getElementById("kt_app_content_container");
  const scheduleContainer = document.getElementById("container-schedule");
  const listsContainer = document.getElementById("container-lists");
  const liveContainer = document.getElementById("container-liveresults");

  if (!competitionCode || !mainContainer) {
	if (mainContainer)
	  mainContainer.innerHTML =
		`<div class="alert alert-danger">Error: CompetitionCode missing in URL.</div>`;
	return;
  }

  /*******************************************************
   * 3) Make API call to settings endpoint
   *******************************************************/
  fetch(
	API_BASE_URL + "?api=settings&competitionCode=" +
	  encodeURIComponent(competitionCode) +
	  "&public=true",
	{
	  method: "GET",
	  headers: {
		"Content-Type": "application/json",
		"Authorization": "Bearer 50afb255cfa3a36834e0a51185b1eb09",
	  },
	}
  )
	.then(resp => {
	  if (!resp.ok) throw new Error(`HTTP error ${resp.status}`);
	  return resp.json();
	})
	.then(data => {
	  // If not found or explicit API error/false success, show alert and return
	  if (!data || data.success === false || !data.settings) {
		mainContainer.innerHTML =
		  `<div class="alert alert-danger">
			<b>Competition not found:</b> No competition found for <code>${competitionCode}</code>.<br>
			Please check your link or try again later.
		  </div>`;
		return;
	  }

	  // --- SHOW CONTAINER IF PUBLISH === 1 ---
	  if (scheduleContainer) {
		if (parseInt(data.settings.publish) === 1) {
		  scheduleContainer.style.display = "block";
		  listsContainer.style.display = "block";
		  liveContainer.style.display = "block";
		  document.getElementById("container-liveresults").innerHTML =
			`<div data-type="kt_app_content_container_results"></div>`;
		} else {
		  scheduleContainer.style.display = "none";
		  listsContainer.style.display = "none";
		  liveContainer.style.display = "none";
		}
	  }
	  // If found, do nothing else (continue normal page load)
	})
	.catch(err => {
	  console.error("Error fetching competition settings:", err);
	  mainContainer.innerHTML =
		`<div class="alert alert-danger">
		  <b>Competition not found:</b> No competition found for <code>${competitionCode}</code>.<br>
		  Please check your link or try again later.
		</div>`;
	});
});