// Function to update event name in the breadcrumb
function updateEventName() {
	const storedEvent = JSON.parse(localStorage.getItem('activeCompetition'));
	const eventNameElement = document.getElementById('event-name');

	if (eventNameElement) {
		if (storedEvent && storedEvent.name) {
			eventNameElement.textContent = storedEvent.name;
		} else {
			eventNameElement.textContent = 'No Event Selected';
		}
	} else {
		console.error('Event name element not found!');
	}
}

// Function to inject the breadcrumb into the DOM
function loadBreadcrumb() {
	const breadcrumbHTML = `
		<div class="container-xxl d-flex app-container flex-stack" id="kt_app_toolbar_container">
			<div class="d-flex flex-column justify-content-center flex-wrap page-title me-3">
				<h1 class="fs-3 fw-bold text-dark d-flex flex-column justify-content-center page-heading my-0">Selected Event</h1>
				<ul class="fw-semibold breadcrumb breadcrumb-separatorless fs-7 my-0 pt-1">
					<li class="text-muted breadcrumb-item">
						<a class="text-muted text-hover-primary" id="event-name" href="dashboard.html">Loading event...</a>
					</li>
				</ul>
			</div>
			<div class="d-flex align-items-center gap-2 gap-lg-3">
				<div class="m-0">
					<div class="menu menu-sub menu-sub-dropdown w-250px w-md-300px" data-kt-menu="true" id="kt_menu_63d123a2c2ed9">
						<div class="px-7 py-5">
							<div class="fs-5 fw-bold text-dark"><span>Filter Options</span></div>
						</div>
						<div class="separator border-gray-200"></div>
						<div class="px-7 py-5">
							<div class="mb-10">
								<label class="form-label fw-semibold form-label">Status:</label>
								<div>
									<select class="form-select form-select-solid select2-hidden-accessible" data-kt-select2="true" data-placeholder="Select option" data-dropdown-parent="#kt_menu_63d123a2c2ed9" data-allow-clear="true">
										<option value=""></option>
										<option value="1">Approved</option>
										<option value="2">Pending</option>
										<option value="3">In Process</option>
										<option value="4">Rejected</option>
									</select>
								</div>
							</div>
							<div class="mb-10">
								<label class="form-label fw-semibold form-label">Member Type:</label>
								<div class="d-flex">
									<label class="form-label form-check form-check-sm form-check-custom form-check-solid me-5">
										<input type="checkbox" class="form-check-input" value="1">
										<span class="form-check-label"> Author </span>
									</label>
									<label class="form-label form-check form-check-sm form-check-custom form-check-solid">
										<input type="checkbox" class="form-check-input" value="2" checked="checked">
										<span class="form-check-label"> Customer </span>
									</label>
								</div>
							</div>
							<div class="mb-10">
								<label class="form-label fw-semibold form-label">Notifications:</label>
								<div class="form-check form-switch form-switch-sm form-check-custom form-check-solid">
									<input type="checkbox" class="form-check-input" value="" name="notifications" checked="">
									<label class="form-label form-check-label"> Enabled </label>
								</div>
							</div>
							<div class="d-flex justify-content-end">
								<button class="btn btn-light btn-sm btn-active-light-primary me-2" type="reset" data-kt-menu-dismiss="true">Reset</button>
								<button class="btn btn-primary btn-sm" type="submit" data-kt-menu-dismiss="true">Apply</button>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	`;
	const breadcrumbContainer = document.getElementById('breadcrumb-container');
	if (breadcrumbContainer) {
		breadcrumbContainer.innerHTML = breadcrumbHTML;
	} else {
		console.error('Breadcrumb container element not found!');
	}
}

// Execute functions on DOM load
document.addEventListener("DOMContentLoaded", function () {
	loadBreadcrumb(); // Load the breadcrumb HTML
	updateEventName(); // Update the event name after breadcrumb is loaded
});

// Listen for storage events (changes made from other tabs)
window.addEventListener('storage', function (event) {
	if (event.key === 'activeCompetition') {
		updateEventName();
	}
});

// Check every second if localStorage has changed (for same-tab changes)
let lastStoredEvent = localStorage.getItem('activeCompetition');
setInterval(function () {
	const currentStoredEvent = localStorage.getItem('activeCompetition');
	if (currentStoredEvent !== lastStoredEvent) {
		lastStoredEvent = currentStoredEvent;
		updateEventName();
	}
}, 2000);