<?php

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
	// Fetch settings
	$competitionCode = $_GET['competitionCode'] ?? null;

	if (!$competitionCode) {
		echo json_encode(['success' => false, 'error' => 'Competition code is required.']);
		exit;
	}

	try {
		// Fetch settings (inkl. 'score_difference', 'place_difference' und 'overruling')
		$query = "
			SELECT 
				settings.*, 
				events.event_name 
			FROM settings 
			LEFT JOIN events ON settings.event = events.id 
			WHERE settings.competition_code = ? 
			LIMIT 1
		";
		$stmt = $conn->prepare($query);
		$stmt->bind_param("s", $competitionCode);
		$stmt->execute();
		$result   = $stmt->get_result();
		$settings = $result->fetch_assoc();
		$stmt->close();

		// Fetch heat systems
		$heatSystemsQuery  = "SELECT id, name, description FROM heatsystems";
		$heatSystemsResult = $conn->query($heatSystemsQuery);
		$heatSystems       = $heatSystemsResult->fetch_all(MYSQLI_ASSOC);

		// Fetch events related to the competition
		$eventsQuery = "
			SELECT id, event_name
			FROM events
			WHERE competition_code = ?
		";
		$eventsStmt = $conn->prepare($eventsQuery);
		$eventsStmt->bind_param("s", $competitionCode);
		$eventsStmt->execute();
		$eventsResult = $eventsStmt->get_result();
		$events       = $eventsResult->fetch_all(MYSQLI_ASSOC);
		$eventsStmt->close();

		if ($settings) {
			// Defaultwerte für Felder, die fehlen
			$settings['judging']           = $settings['judging']           ?? null; 
			$settings['mode']              = $settings['mode']              ?? null; 
			$settings['sheets']            = $settings['sheets']            ?? 0; 
			$settings['judges']            = $settings['judges']            ?? 3;     
			$settings['runtime']           = $settings['runtime']           ?? 180;   
			$settings['score_difference']  = $settings['score_difference']  ?? 25;  
			$settings['place_difference']  = $settings['place_difference']  ?? 3;  
			$settings['overruling']        = $settings['overruling']        ?? 0;
			$settings['live_schedule']     = $settings['live_schedule']     ?? 1;
		    $settings['publish']           = $settings['publish']           ?? null;
			$settings['livestream']        = $settings['livestream']        ?? null;
			$settings['team_results']      = $settings['team_results']        ?? 0;
		}

		echo json_encode([
			'success'    => true,
			'settings'   => $settings ?: null,
			'heatsystems'=> $heatSystems,
			'events'     => $events
		]);
	} catch (Exception $e) {
		http_response_code(500); // Internal Server Error
		echo json_encode([
			'success' => false, 
			'error'   => 'Unexpected error: ' . $e->getMessage()
		]);
		exit;
	}
}
elseif ($method === 'POST' || $method === 'OPTIONS') {
	// Save or update settings
	$input           = json_decode(file_get_contents('php://input'), true);
	$competitionCode = $input['competitionCode'] ?? null;
	$settings        = $input['settings']        ?? null;

	if (!$competitionCode || !$settings) {
		echo json_encode(['success' => false, 'error' => 'Invalid data provided.']);
		exit;
	}

	try {
		// Check if competition_code exists in the settings table
		$checkQuery = "SELECT 1 FROM settings WHERE competition_code = ?";
		$checkStmt  = $conn->prepare($checkQuery);
		$checkStmt->bind_param("s", $competitionCode);
		$checkStmt->execute();
		$checkResult = $checkStmt->get_result();
		$exists      = $checkResult->num_rows > 0;
		$checkStmt->close();

		$scoreDifference = isset($settings['score_difference']) 
			? (int)$settings['score_difference'] 
			: 0;
		$placeDifference = isset($settings['place_difference']) 
			? (int)$settings['place_difference'] 
			: 0;
		$overrulingVal   = isset($settings['overruling']) 
			? (int)$settings['overruling'] 
			: 0; // Checkbox => '1' oder '0'
			
		$liveSchedule   = isset($settings['live_schedule']) 
		? (int)$settings['live_schedule'] 
		: 0; // Checkbox => '1' oder '0'
		
		$publish   = isset($settings['publish']) 
		? (int)$settings['publish'] 
		: 0; // Checkbox => '1' oder '0'
		
		$livestream = $settings['livestream'] ?? null;
		
		$team_results = $settings['team_results'] ?? 0;


		if ($exists) {
			// Update existing row
			$updateQuery = "
				UPDATE settings 
				SET 
					heatsystem        = ?, 
					judges            = ?, 
					judging           = ?, 
					mode              = ?,
					sheets            = ?, 
					runtime           = ?, 
					score_difference  = ?,
					place_difference  = ?,
					overruling        = ?,
					live_schedule     = ?,
					publish           = ?,
					livestream        = ?,
					team_results      = ?
				WHERE competition_code = ?
			";
			$stmt = $conn->prepare($updateQuery);
			// 8 int params, 1 string param => 'iiiiiiiis'
			$stmt->bind_param(
				"iiiiiiiiiiisis",
				$settings['heatsystem'],
				$settings['judges'],
				$settings['judging'],
				$settings['mode'],
				$settings['sheets'],
				$settings['runtime'],
				$scoreDifference,
				$placeDifference,
				$overrulingVal,
				$liveSchedule,
				$publish,
				$livestream,
				$team_results,
				$competitionCode
			);
		} else {
			// Insert new row
			$insertQuery = "
				INSERT INTO settings (
					competition_code,
					heatsystem,
					judges,
					judging,
					mode,
					sheets,
					runtime,
					score_difference,
					place_difference,
					overruling,
					live_schedule,
					publish,
					livestream,
					team_results
				)
				VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
			";
			$stmt = $conn->prepare($insertQuery);
			// 1 string + 8 ints => "siiiiiiii"
			$stmt->bind_param(
				"siiiiiiiiiiis",
				$competitionCode,
				$settings['heatsystem'],
				$settings['judges'],
				$settings['judging'],
				$settings['mode'],
				$settings['sheets'],
				$settings['runtime'],
				$scoreDifference,
				$placeDifference,
				$overrulingVal,
				$liveSchedule,
				$publish,
				$livestream,
				$team_results
			);
		}

		if (!$stmt->execute()) {
			throw new Exception("Database execution failed: " . $stmt->error);
		}
		$stmt->close();

		echo json_encode(['success' => true, 'message' => 'Settings saved successfully.']);
	} catch (Exception $e) {
		http_response_code(500); // Internal Server Error
		echo json_encode([
			'success' => false, 
			'error'   => 'Error saving settings: ' . $e->getMessage()
		]);
		exit;
	}
}
else {
	// Handle invalid methods
	http_response_code(405); // Method Not Allowed
	echo json_encode(['success' => false, 'error' => 'Method not allowed.']);
}

?>