<?php

// Get the POST data
$input = json_decode(file_get_contents('php://input'), true);
$email = $input['email'] ?? null;
$password = $input['password'] ?? null;

if (!$email || !$password) {
	echo json_encode(['success' => false, 'error' => 'Email and password are required.']);
	exit;
}

try {
	// Hash the password using MD5
	$hashedPassword = md5($password);

	// Update the user's password and set the token fields to NULL
	$query = "UPDATE user SET password = ?, token = NULL, token_expiration = NULL WHERE email = ?";
	$stmt = $conn->prepare($query);
	$stmt->bind_param("ss", $hashedPassword, $email);
	$stmt->execute();

	if ($stmt->affected_rows > 0) {
		echo json_encode(['success' => true, 'message' => 'Signup successful.']);
	} else {
		echo json_encode(['success' => false, 'error' => 'Failed to update user. Email not found or token already used.']);
	}

	$stmt->close();
} catch (Exception $e) {
	http_response_code(500); // Internal Server Error
	echo json_encode(['success' => false, 'error' => 'Database error: ' . $e->getMessage()]);
	exit;
}
?>