<?php

// Get the token from the request
$token = $_GET['token'] ?? null;

if (!$token) {
	echo json_encode(['success' => false, 'error' => 'Token is required.']);
	exit;
}

try {
	// Query to fetch the email address associated with the token
	$query = "SELECT email FROM user WHERE token = ? AND token_expiration >= NOW()";
	$stmt = $conn->prepare($query);
	$stmt->bind_param("s", $token);
	$stmt->execute();
	$result = $stmt->get_result();

	if ($result->num_rows > 0) {
		$row = $result->fetch_assoc();
		echo json_encode(['success' => true, 'email' => $row['email']]);
	} else {
		echo json_encode(['success' => false, 'error' => 'Invalid or expired token.']);
	}

	$stmt->close();
} catch (Exception $e) {
	http_response_code(500); // Internal Server Error
	echo json_encode(['success' => false, 'error' => 'Database error: ' . $e->getMessage()]);
	exit;
}
?>