<?php
/**
 * Ermittelt die Anzahl der Athleten pro Kategorie und Geschlecht für eine bestimmte Competition aus der Tabelle "athletes".
 * 
 * @param mysqli $conn Die MySQLi-Datenbankverbindung.
 * @param string $competitionCode Der Code der Competition, für die die Athletenanzahl ermittelt werden soll.
 * @return array Ein assoziatives Array mit der Kategorie und dem Geschlecht als Schlüssel und der Athletenanzahl als Wert.
 */
function getAthleteCountPerCategory($conn, $competitionCode, $event_id) {
	
	$sqlGetEventCode = "
		SELECT event_code
		FROM events
		WHERE id = ?
		LIMIT 1
	";
	$stmtEvent = $conn->prepare($sqlGetEventCode);
	$stmtEvent->bind_param("i", $event_id);
	$stmtEvent->execute();
	$resultEvent = $stmtEvent->get_result();
	$rowEvent    = $resultEvent->fetch_assoc();
	$stmtEvent->close();
	$eventCode = $rowEvent['event_code'];
	
	$query = "
		SELECT category_in_competition, gender, COUNT(*) AS athlete_count
		FROM athletes
		WHERE competition_code = ? AND event_code = ?
		GROUP BY category_in_competition, gender;
	";
	
	$stmt = $conn->prepare($query);
	$stmt->bind_param("ss", $competitionCode, $eventCode);  // Bindet den Event-Code an die Abfrage
	$stmt->execute();
	$result = $stmt->get_result();
	$categoryCounts = [];

	if ($result->num_rows > 0) {
		while ($row = $result->fetch_assoc()) {
			$category = $row['category_in_competition'];
			$gender = $row['gender'];
			$count = $row['athlete_count'];
			
			// Strukturieren der Ausgabe nach Kategorie und Geschlecht
			if (!isset($categoryCounts[$category])) {
				$categoryCounts[$category] = [];
			}
			$categoryCounts[$category][$gender] = $count;
		}
	}

	$stmt->close();
	
	return $categoryCounts;
}
?>